<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'جزئیات کاربر';
$db = Database::getInstance();

// دریافت ID کاربر
$userId = (int)get('id', 0);

if (!$userId) {
    redirect('users.php');
}

// دریافت اطلاعات کاربر
$user = $db->fetchOne("
    SELECT u.*,
           s.plan_type, s.status as subscription_status,
           s.current_period_start, s.current_period_end,
           s.payment_method,
           a.role as admin_role
    FROM users u
    LEFT JOIN subscriptions s ON u.id = s.user_id AND s.status = 'active'
    LEFT JOIN admins a ON u.id = a.user_id
    WHERE u.id = ?
", [$userId]);

if (!$user) {
    redirect('users.php');
}

// آمار کاربر
$stats = [
    'total_cycles' => 0,
    'this_month_cycles' => 0,
    'avg_hawkins_level' => 0,
    'last_cycle_date' => null
];

$recent_cycles = [];
$ban_logs = [];

try {
    // بررسی وجود جدول cycles
    $stats['total_cycles'] = $db->count('cycles', 'user_id = ?', [$userId]);

    $thisMonthResult = $db->fetchOne("
        SELECT COUNT(*) as count
        FROM cycles
        WHERE user_id = ? AND DATE(created_at) >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)
    ", [$userId]);
    if ($thisMonthResult) {
        $stats['this_month_cycles'] = $thisMonthResult['count'] ?? 0;
    }

    $avgResult = $db->fetchOne("
        SELECT AVG(hawkins_level) as avg_level
        FROM cycles
        WHERE user_id = ?
    ", [$userId]);
    if ($avgResult) {
        $stats['avg_hawkins_level'] = $avgResult['avg_level'] ?? 0;
    }

    $lastCycleResult = $db->fetchOne("
        SELECT MAX(created_at) as last_date
        FROM cycles
        WHERE user_id = ?
    ", [$userId]);
    if ($lastCycleResult) {
        $stats['last_cycle_date'] = $lastCycleResult['last_date'] ?? null;
    }

    // آخرین چرخه‌ها
    $recent_cycles = $db->fetchAll("
        SELECT id, hawkins_level, awareness_level, created_at
        FROM cycles
        WHERE user_id = ?
        ORDER BY created_at DESC
        LIMIT 10
    ", [$userId]);
} catch (Exception $e) {
    // اگر جدول cycles وجود ندارد، خطا را نادیده بگیر
}

try {
    // تاریخچه Ban
    $ban_logs = $db->fetchAll("
        SELECT bl.*, u.full_name as admin_name
        FROM ban_logs bl
        LEFT JOIN users u ON bl.admin_id = u.id
        WHERE bl.user_id = ?
        ORDER BY bl.created_at DESC
        LIMIT 10
    ", [$userId]);
} catch (Exception $e) {
    // اگر جدول ban_logs وجود ندارد، خطا را نادیده بگیر
}

include 'php/includes/header.php';
?>


<div class="row clearfix">
    <div class="col-lg-12">
        <a href="users.php" class="btn-action waves-effect m-b-15">
            <i class="material-icons">arrow_back</i>
            <span>بازگشت به لیست کاربران</span>
        </a>
    </div>
</div>

<div class="row clearfix">
    <!-- اطلاعات پروفایل -->
    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
        <div class="card">
            <div class="header bg-<?php echo $user['status'] === 'banned' ? 'red' : 'cyan'; ?>">
                <h2 class="text-white">اطلاعات شخصی</h2>
            </div>
            <div class="body">
                <div class="text-center m-b-20">
                    <i class="material-icons" style="font-size: 64px; color: #999;">account_circle</i>
                    <h4 class="m-t-10"><?php echo h($user['full_name'] ?? 'کاربر بدون نام'); ?></h4>
                    <p class="text-muted"><?php echo h($user['email']); ?></p>
                    <?php echo getUserStatusBadge($user['status']); ?>
                </div>

                <table class="table table-condensed">
                    <tr>
                        <th width="40%">ID:</th>
                        <td><?php echo $user['id']; ?></td>
                    </tr>
                    <tr>
                        <th>نام کاربری:</th>
                        <td><?php echo h($user['username'] ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>جنسیت:</th>
                        <td><?php echo getGenderLabel($user['gender']); ?></td>
                    </tr>
                    <tr>
                        <th>سن:</th>
                        <td><?php echo $user['age'] ?? '-'; ?></td>
                    </tr>
                    <tr>
                        <th>تاریخ تولد:</th>
                        <td><?php echo $user['birth_date'] ? formatDate($user['birth_date'], 'Y/m/d') : '-'; ?></td>
                    </tr>
                    <tr>
                        <th>زبان:</th>
                        <td><?php echo strtoupper($user['language'] ?? 'fa'); ?></td>
                    </tr>
                    <tr>
                        <th>تقویم:</th>
                        <td><?php echo $user['calendar_type'] ?? 'gregorian'; ?></td>
                    </tr>
                    <tr>
                        <th>تاریخ عضویت:</th>
                        <td><?php echo formatDate($user['created_at']); ?></td>
                    </tr>
                    <tr>
                        <th>آخرین آنلاین:</th>
                        <td><?php echo $user['last_online'] ? timeAgo($user['last_online']) : '-'; ?></td>
                    </tr>
                    <tr>
                        <th>تعداد ورود:</th>
                        <td><?php echo number_format($user['total_login_count'] ?? 0); ?></td>
                    </tr>
                </table>

                <?php if ($user['admin_role']): ?>
                <div class="alert alert-info">
                    <strong>نقش ادمین:</strong> <?php echo get_role_label($user['admin_role']); ?>
                </div>
                <?php endif; ?>

                <?php if ($user['status'] === 'banned'): ?>
                <div class="alert alert-danger">
                    <strong>دلیل مسدودی:</strong><br>
                    <?php echo h($user['ban_reason'] ?? 'نامشخص'); ?>
                    <?php if ($user['ban_message']): ?>
                        <br><br><strong>پیام:</strong><br>
                        <?php echo nl2br(h($user['ban_message'])); ?>
                    <?php endif; ?>
                    <br><br>
                    <small>مسدود شده در: <?php echo formatDate($user['banned_at']); ?></small>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- عملیات ادمین -->
        <div class="card">
            <div class="header">
                <h2>عملیات مدیریت</h2>
            </div>
            <div class="body">
                <?php if ($user['status'] === 'banned'): ?>
                    <a href="api/user_unban.php?id=<?php echo $user['id']; ?>" class="btn btn-success btn-block waves-effect" onclick="return confirm('آیا مطمئن هستید که می‌خواهید مسدودیت این کاربر را رفع کنید؟');">
                        <i class="material-icons">check_circle</i>
                        رفع مسدودیت
                    </a>
                <?php else: ?>
                    <a href="user_ban.php?id=<?php echo $user['id']; ?>" class="btn btn-warning btn-block waves-effect">
                        <i class="material-icons">block</i>
                        مسدود کردن
                    </a>
                <?php endif; ?>

                <a href="user_edit.php?id=<?php echo $user['id']; ?>" class="btn btn-primary btn-block waves-effect">
                    <i class="material-icons">edit</i>
                    ویرایش اطلاعات
                </a>

                <button type="button" class="btn btn-info btn-block waves-effect" data-toggle="modal" data-target="#sendNotificationModal">
                    <i class="material-icons">notifications</i>
                    ارسال اعلان
                </button>

                <button type="button" class="btn btn-default btn-block waves-effect" onclick="resetPassword()">
                    <i class="material-icons">vpn_key</i>
                    ریست رمز عبور
                </button>

                <hr>

                <button type="button" class="btn btn-danger btn-block waves-effect" onclick="confirmDelete()">
                    <i class="material-icons">delete_forever</i>
                    حذف حساب کاربری
                </button>
            </div>
        </div>
    </div>

    <!-- اطلاعات دستگاه و اشتراک -->
    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
        <!-- آمار کلی -->
        <div class="row clearfix">
            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                <div class="info-box-3 bg-cyan hover-expand-effect">
                    <div class="icon">
                        <i class="material-icons">loop</i>
                    </div>
                    <div class="content">
                        <div class="text">کل چرخه‌ها</div>
                        <div class="number"><?php echo number_format($stats['total_cycles']); ?></div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                <div class="info-box-3 bg-light-green hover-expand-effect">
                    <div class="icon">
                        <i class="material-icons">trending_up</i>
                    </div>
                    <div class="content">
                        <div class="text">این ماه</div>
                        <div class="number"><?php echo number_format($stats['this_month_cycles']); ?></div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                <div class="info-box-3 bg-orange hover-expand-effect">
                    <div class="icon">
                        <i class="material-icons">show_chart</i>
                    </div>
                    <div class="content">
                        <div class="text">میانگین هاوکینز</div>
                        <div class="number"><?php echo number_format($stats['avg_hawkins_level'], 1); ?></div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                <div class="info-box-3 bg-purple hover-expand-effect">
                    <div class="icon">
                        <i class="material-icons">access_time</i>
                    </div>
                    <div class="content">
                        <div class="text">آخرین چرخه</div>
                        <div class="number" style="font-size: 14px;">
                            <?php echo $stats['last_cycle_date'] ? timeAgo($stats['last_cycle_date']) : '-'; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- اطلاعات اشتراک -->
        <div class="card">
            <div class="header">
                <h2>اشتراک فعلی</h2>
            </div>
            <div class="body">
                <?php if ($user['plan_type']): ?>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>نوع پلن:</strong> <?php echo getPlanBadge($user['plan_type']); ?></p>
                        <p><strong>روش پرداخت:</strong> <?php echo h($user['payment_method'] ?? '-'); ?></p>
                        <p><strong>وضعیت:</strong> <?php echo getUserStatusBadge($user['subscription_status'] ?? 'inactive'); ?></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>تاریخ شروع:</strong> <?php echo formatDate($user['current_period_start']); ?></p>
                        <p><strong>تاریخ پایان:</strong> <?php echo formatDate($user['current_period_end']); ?></p>
                    </div>
                </div>
                <?php else: ?>
                <p class="text-muted">هیچ اشتراک فعالی وجود ندارد.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- اطلاعات دستگاه -->
        <div class="card">
            <div class="header">
                <h2>اطلاعات دستگاه و مرورگر</h2>
            </div>
            <div class="body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>IP:</strong> <?php echo h($user['last_ip'] ?? '-'); ?></p>
                        <p><strong>سیستم عامل:</strong> <?php echo h($user['last_os'] ?? '-'); ?></p>
                        <p><strong>مرورگر:</strong> <?php echo h($user['last_browser'] ?? '-'); ?></p>
                        <p><strong>پلتفرم:</strong> <?php echo h($user['last_platform'] ?? '-'); ?></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>نوع دستگاه:</strong> <?php echo h($user['last_device_type'] ?? '-'); ?></p>
                        <p><strong>مدل دستگاه:</strong> <?php echo h($user['device_model'] ?? '-'); ?></p>
                        <p><strong>وضوح صفحه:</strong> <?php echo h($user['screen_resolution'] ?? '-'); ?></p>
                        <p><strong>PWA نصب شده:</strong>
                            <?php echo $user['is_pwa_installed'] ? '<span class="badge bg-green">بله</span>' : '<span class="badge bg-grey">خیر</span>'; ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- آخرین چرخه‌ها -->
        <div class="card">
            <div class="header">
                <h2>آخرین چرخه‌های ثبت شده</h2>
            </div>
            <div class="body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>سطح هاوکینز</th>
                                <th>سطح آگاهی</th>
                                <th>تاریخ ثبت</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recent_cycles as $cycle): ?>
                            <tr>
                                <td><?php echo $cycle['id']; ?></td>
                                <td><?php echo number_format($cycle['hawkins_level'] ?? 0); ?></td>
                                <td><?php echo number_format($cycle['awareness_level'] ?? 0, 2); ?></td>
                                <td><?php echo formatDate($cycle['created_at']); ?></td>
                                <td>
                                    <button class="btn btn-xs btn-info" onclick="viewCycle(<?php echo $cycle['id']; ?>)">
                                        <i class="material-icons">visibility</i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>

                            <?php if (empty($recent_cycles)): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted">هیچ چرخه‌ای ثبت نشده است.</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- تاریخچه Ban/Unban -->
        <?php if (!empty($ban_logs)): ?>
        <div class="card">
            <div class="header">
                <h2>تاریخچه مسدودی</h2>
            </div>
            <div class="body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>نوع</th>
                                <th>دلیل</th>
                                <th>توسط</th>
                                <th>تاریخ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($ban_logs as $log): ?>
                            <tr>
                                <td>
                                    <?php if ($log['action'] === 'ban'): ?>
                                        <span class="badge bg-red">مسدود</span>
                                    <?php else: ?>
                                        <span class="badge bg-green">رفع مسدودی</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo h($log['reason'] ?? '-'); ?></td>
                                <td><?php echo h($log['admin_name'] ?? 'نامشخص'); ?></td>
                                <td><?php echo formatDate($log['created_at']); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modal: ارسال اعلان -->
<div class="modal fade" id="sendNotificationModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">ارسال اعلان به کاربر</h4>
            </div>
            <div class="modal-body">
                <form id="notificationForm">
                    <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">

                    <div class="form-group">
                        <label>عنوان</label>
                        <input type="text" name="title" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label>متن پیام</label>
                        <textarea name="body" class="form-control" rows="4" required></textarea>
                    </div>

                    <div class="form-group">
                        <label>لینک (اختیاری)</label>
                        <input type="url" name="link" class="form-control">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">انصراف</button>
                <button type="button" class="btn btn-primary waves-effect" onclick="sendNotification()">ارسال</button>
            </div>
        </div>
    </div>
</div>

<script>
function sendNotification() {
    const form = document.getElementById('notificationForm');
    const formData = new FormData(form);

    fetch('../api/send_notification.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('اعلان با موفقیت ارسال شد.');
            $('#sendNotificationModal').modal('hide');
        } else {
            alert('خطا: ' + data.message);
        }
    });
}

function confirmDelete() {
    if (confirm('آیا از حذف این کاربر اطمینان دارید؟\n\nاین عمل قابل بازگشت نیست و تمام اطلاعات کاربر به طور کامل حذف خواهد شد.\n\nبرای تایید روی OK کلیک کنید.')) {
        if (confirm('آخرین هشدار!\n\nآیا واقعاً مطمئن هستید که می‌خواهید این کاربر را حذف کنید؟')) {
            window.location.href = 'api/user_delete.php?id=<?php echo $user['id']; ?>';
        }
    }
}

function resetPassword() {
    if (confirm('آیا می‌خواهید رمز عبور این کاربر را ریست کنید؟')) {
        // اینجا باید API ریست رمز اضافه شود
        alert('این قابلیت به زودی اضافه می‌شود.');
    }
}

function viewCycle(id) {
    // اینجا می‌توان صفحه جزئیات چرخه را باز کرد
    alert('مشاهده چرخه #' + id + '\nاین قابلیت به زودی اضافه می‌شود.');
}
</script>

<?php include 'php/includes/footer.php'; ?>
