<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'مدیریت کد تخفیف';
$db = Database::getInstance();

// دریافت لیست کدهای تخفیف
$discounts = $db->query("
    SELECT * FROM discount_codes
    ORDER BY created_at DESC
")->fetchAll();

$total = count($discounts);

include 'php/includes/header.php';
?>

<div class="row clearfix">
    <div class="col-lg-12">
        <div class="card">
            <div class="header">
                <h2>
                    مدیریت کد تخفیف
                    <small><?php echo number_format($total); ?> کد</small>
                </h2>
                <ul class="header-dropdown m-r--5">
                    <li>
                        <a href="discount_code_create.php" class="btn-action btn-save waves-effect">
                            <i class="material-icons">add</i>
                            <span>افزودن کد جدید</span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th>کد</th>
                                <th>نوع</th>
                                <th>مقدار</th>
                                <th>پلن</th>
                                <th>تعداد مجاز</th>
                                <th>استفاده شده</th>
                                <th>باقی‌مانده</th>
                                <th>تاریخ انقضا</th>
                                <th>وضعیت</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($discounts as $discount): ?>
                            <?php
                            $used = $discount['used_count'] ?? 0;
                            $maxUses = $discount['max_uses'] ?? 0;
                            $remaining = $maxUses > 0 ? max(0, $maxUses - $used) : '∞';
                            $isExpired = $discount['expires_at'] && strtotime($discount['expires_at']) < time();
                            $isActive = $discount['is_active'] && !$isExpired && ($maxUses == 0 || $remaining > 0);
                            ?>
                            <tr>
                                <td><strong><?php echo h($discount['code']); ?></strong></td>
                                <td>
                                    <?php echo $discount['discount_type'] === 'percentage' ? 'درصدی' : 'مبلغ ثابت'; ?>
                                </td>
                                <td>
                                    <?php
                                    echo $discount['discount_type'] === 'percentage'
                                        ? $discount['discount_value'] . '%'
                                        : number_format($discount['discount_value']) . ' تومان';
                                    ?>
                                </td>
                                <td>
                                    <?php echo $discount['plan_type'] ? getPlanBadge($discount['plan_type']) : '<span class="badge bg-grey">همه</span>'; ?>
                                </td>
                                <td><?php echo $maxUses > 0 ? number_format($maxUses) : 'نامحدود'; ?></td>
                                <td><?php echo number_format($used); ?></td>
                                <td>
                                    <?php
                                    if ($remaining === '∞') {
                                        echo '<span class="badge bg-green">نامحدود</span>';
                                    } else {
                                        $color = $remaining == 0 ? 'bg-red' : ($remaining < 5 ? 'bg-orange' : 'bg-green');
                                        echo '<span class="badge ' . $color . '">' . number_format($remaining) . '</span>';
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    if ($discount['expires_at']) {
                                        echo formatDate($discount['expires_at']);
                                        if ($isExpired) {
                                            echo '<br><span class="badge bg-red">منقضی شده</span>';
                                        }
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php if ($isActive): ?>
                                        <span class="badge bg-green">فعال</span>
                                    <?php else: ?>
                                        <span class="badge bg-grey">غیرفعال</span>
                                    <?php endif; ?>
                                </td>
                                <td class="table-actions">
                                    <a href="discount_code_edit.php?id=<?php echo $discount['id']; ?>" class="btn btn-xs btn-primary" title="ویرایش">
                                        <i class="material-icons">edit</i>
                                    </a>
                                    <a href="api/discount_code_delete.php?id=<?php echo $discount['id']; ?>" class="btn btn-xs btn-danger btn-delete" title="حذف">
                                        <i class="material-icons">delete</i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>

                            <?php if (empty($discounts)): ?>
                            <tr>
                                <td colspan="10" class="text-center">هیچ کد تخفیفی یافت نشد</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$('.btn-delete').on('click', function(e) {
    e.preventDefault();
    if (confirm('آیا از حذف این کد تخفیف اطمینان دارید؟')) {
        window.location.href = $(this).attr('href');
    }
});
</script>

<?php include 'php/includes/footer.php'; ?>
