<?php
define('AYENEH_ADMIN', true);
require_once '../php/autoload.php';

$db = Database::getInstance();
$session = Session::getInstance();
$auth = Auth::getInstance();

// بررسی لاگین بودن
if (!$auth->isLoggedIn()) {
    $session->setError('لطفا ابتدا وارد شوید.');
    redirect('../login.php');
}

$adminId = (int)get('id', 0);
$action = get('action', ''); // 'enable' or 'disable'

if (!$adminId) {
    $session->setError('شناسه ادمین نامعتبر است.');
    redirect('../admins.php');
}

// بررسی وجود ادمین
$admin = $db->fetchOne("SELECT id, user_id, two_factor_enabled FROM admins WHERE id = ?", [$adminId]);
if (!$admin) {
    $session->setError('ادمین یافت نشد.');
    redirect('../admins.php');
}

// فقط Super Admin می‌تواند 2FA دیگران را تغییر دهد
// اما هر ادمینی می‌تواند 2FA خودش را تغییر دهد
$isSelf = ($admin['user_id'] == $auth->getUserId());
$isSuperAdmin = $auth->hasRole('super_admin');

if (!$isSelf && !$isSuperAdmin) {
    $session->setError('شما فقط می‌توانید 2FA خودتان را تغییر دهید.');
    redirect('../admins.php');
}

try {
    if ($action === 'enable') {
        // فعال کردن 2FA
        require_once '../../vendor/autoload.php';

        $google2fa = new \PragmaRX\Google2FA\Google2FA();
        $secret = $google2fa->generateSecretKey();

        // تولید backup codes
        $backupCodes = [];
        for ($i = 0; $i < 10; $i++) {
            $backupCodes[] = strtoupper(bin2hex(random_bytes(4)));
        }

        $db->update('admins', [
            'two_factor_enabled' => 1,
            'two_factor_secret' => $secret,
            'two_factor_backup_codes' => json_encode($backupCodes),
            'updated_at' => date('Y-m-d H:i:s')
        ], 'id = ?', [$adminId]);

        // ذخیره اطلاعات در session برای نمایش QR Code
        $_SESSION['2fa_setup'] = [
            'admin_id' => $adminId,
            'secret' => $secret,
            'backup_codes' => $backupCodes
        ];

        $session->setSuccess('2FA برای این ادمین فعال شد. کدهای بازیابی را یادداشت کنید.');
        redirect('../admin_2fa_setup.php?id=' . $adminId);

    } elseif ($action === 'disable') {
        // غیرفعال کردن 2FA
        $db->update('admins', [
            'two_factor_enabled' => 0,
            'two_factor_secret' => null,
            'two_factor_backup_codes' => null,
            'updated_at' => date('Y-m-d H:i:s')
        ], 'id = ?', [$adminId]);

        $session->setSuccess('2FA برای این ادمین غیرفعال شد.');
        redirect('../admins.php');

    } else {
        $session->setError('عملیات نامعتبر است.');
        redirect('../admins.php');
    }

} catch (Exception $e) {
    $session->setError('خطا در تغییر وضعیت 2FA: ' . $e->getMessage());
    redirect('../admins.php');
}
